/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package exampleExceptions;

import java.io.FileNotFoundException;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class StartHere {

    public static void main(String[] args) {
        //Run some code that takes us too much memory
//        memoryProblems();    
        //Run some code that tries to reference an index is too big for the array.
//        arrayProblems();
        //Run some code that tries to divide by 0
        double result=arithmeticProblems(1,0);
        //Run some code that tries to open a file that doesn't exist.
//        fileProblems();
    }

    //Methods which raise some common exceptions and errors.
    //These methods are designed to illustrate handling exceptions and errors.
    //it is unlikely you would every write code to deliberately raise 
    //these exceptons.
    public static void memoryProblems() {
        throw new OutOfMemoryError();
    }

    public static void arrayProblems() {
        int[] myArray = {1, 2, 3};
        //This will generate an ArrayIndexOutOfBoundException
        System.out.println("Value in position 4: " + myArray[3]);
    }

    public static double arithmeticProblems(int a, int b) {
        //This could generate an ArithmeticException.
       return a/b;
    }

    public static void fileProblems() throws FileNotFoundException {
        throw new FileNotFoundException();
    }

}
